/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.sim.toolkit.viewer.VWSIMAnimatorMap;
import filenet.sim.toolkit.viewer.VWSIMAnimatorScenario;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

public class VWSIMAnimatorWorkflow {
    private VWSIMAnimatorScenario m_scenario = null;
    private VWWorkflowDefinition m_workflowDefinition = null;
    private int m_workClassId = -1;
    private int m_launchedCount = 0;
    private int m_activeCount = 0;
    private int m_completedCount = 0;
    private int m_overdueCount = 0;
    private double m_cost = 0.0;
    private double m_averageCost = 0.0;
    private long m_minCycleTime = 0L;
    private long m_maxCycleTime = 0L;
    private long m_aveCycleTime = 0L;
    private Vector m_maps = null;
    private String m_name = null;

    public VWSIMAnimatorWorkflow(VWSIMAnimatorScenario scenario, VWWorkflowDefinition def, String workClassId) throws Exception {
        this.m_scenario = scenario;
        this.m_workflowDefinition = def;
        this.m_workClassId = def.getRuntimeId().getWorkClassId();
        this.m_maps = new Vector();
        if (this.m_workflowDefinition != null) {
            String name = this.m_workflowDefinition.getName();
            if (name != null) {
                int first = name.indexOf(34);
                int last = name.lastIndexOf(34);
                this.m_name = first != -1 && last != -1 ? name.substring(first + 1, last) : name;
            } else {
                this.m_name = new String();
            }
            VWMapDefinition mainMap = this.m_workflowDefinition.getMainMap();
            String mainMapName = null;
            mainMapName = mainMap != null ? mainMap.getName() : "";
            VWMapDefinition[] maps = this.m_workflowDefinition.getMaps();
            if (maps != null) {
                for (int i = 0; i < maps.length; ++i) {
                    if (maps[i] == null) continue;
                    String mapName = maps[i].getName();
                    boolean bMainMap = VWStringUtils.compare(mapName, mainMapName) == 0;
                    VWSIMAnimatorMap animatorMap = new VWSIMAnimatorMap(this, maps[i], bMainMap);
                    if (bMainMap) continue;
                    String aMapName = null;
                    Object obj = null;
                    int index = -1;
                    for (int j = 0; j < this.m_maps.size(); ++j) {
                        obj = this.m_maps.elementAt(j);
                        if (obj == null || !(obj instanceof VWSIMAnimatorMap) || VWStringUtils.compare(mapName, aMapName = ((VWSIMAnimatorMap)obj).getMapName()) >= 0) continue;
                        index = j;
                    }
                    if (index == -1) {
                        this.m_maps.add(animatorMap);
                        continue;
                    }
                    this.m_maps.add(index, animatorMap);
                }
                if (mainMap != null) {
                    this.m_maps.add(0, new VWSIMAnimatorMap(this, mainMap, true));
                }
                Object obj = null;
                Object map = null;
                if (this.m_maps != null && this.m_maps.size() > 0) {
                    for (int i = 0; i < this.m_maps.size(); ++i) {
                        obj = this.m_maps.elementAt(i);
                        if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                        ((VWSIMAnimatorMap)obj).initStepDefinition();
                    }
                }
            }
        }
    }

    public VWSIMAnimatorWorkflow(String name) throws Exception {
        this.m_name = name;
    }

    public int getWorkClassId() {
        return this.m_workClassId;
    }

    public VWWorkflowDefinition getWorkflowDefinition() {
        return this.m_workflowDefinition;
    }

    public VWSIMAnimatorMap getMap(String mapName) {
        if (mapName != null && this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                String name;
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap) || (name = ((VWSIMAnimatorMap)obj).getMapName()) == null || VWStringUtils.compare(name, mapName) != 0) continue;
                return (VWSIMAnimatorMap)obj;
            }
        }
        return null;
    }

    public VWSIMAnimatorMap getMap(int mapId) {
        if (this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap) || ((VWSIMAnimatorMap)obj).getMapId() != mapId) continue;
                return (VWSIMAnimatorMap)obj;
            }
        }
        return null;
    }

    public VWSIMAnimatorScenario getScenario() {
        return this.m_scenario;
    }

    public String getName() {
        if (this.m_name != null) {
            return this.m_name;
        }
        return new String("");
    }

    public Vector getMaps() {
        return this.m_maps;
    }

    public VWSIMAnimatorMap getMainMap() {
        if (this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap) || !((VWSIMAnimatorMap)obj).isMainMap()) continue;
                return (VWSIMAnimatorMap)obj;
            }
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public synchronized void clearStatistics() {
        if (this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                ((VWSIMAnimatorMap)obj).clearStatistics();
            }
        }
    }

    public boolean isSelected() {
        if (this.m_maps != null && this.m_maps.size() > 0) {
            Object map = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                Object obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap) || !((VWSIMAnimatorMap)obj).isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized int getLaunchedCount() {
        return this.m_launchedCount;
    }

    public synchronized int getActiveCount() {
        return this.m_activeCount;
    }

    public synchronized int getCompletedCount() {
        return this.m_completedCount;
    }

    public synchronized int getOverdueCount() {
        return this.m_overdueCount;
    }

    public synchronized double getCost() {
        return this.m_cost;
    }

    public synchronized double getAverageCost() {
        return this.m_averageCost;
    }

    public synchronized long getMinCycleTime() {
        return this.m_minCycleTime;
    }

    public synchronized long getMaxCycleTime() {
        return this.m_maxCycleTime;
    }

    public synchronized long getAverageCycleTime() {
        return this.m_aveCycleTime;
    }

    public synchronized void setLaunchedCount(int count) {
        this.m_launchedCount = count;
    }

    public synchronized void setActiveCount(int count) {
        this.m_activeCount = count;
    }

    public synchronized void setCompletedCount(int count) {
        this.m_completedCount = count;
    }

    public synchronized void setOverdueCount(int count) {
        this.m_overdueCount = count;
    }

    public synchronized void setCost(double cost) {
        this.m_cost = cost;
    }

    public synchronized void setAverageCost(double cost) {
        this.m_averageCost = cost;
    }

    public synchronized void setMinCycleTime(long time) {
        this.m_minCycleTime = time;
    }

    public synchronized void setMaxCycleTime(long time) {
        this.m_maxCycleTime = time;
    }

    public synchronized void setAverageCycleTime(long time) {
        this.m_aveCycleTime = time;
    }

    void releaseResources() {
        this.m_scenario = null;
        this.m_workflowDefinition = null;
        this.m_name = null;
        if (this.m_maps != null) {
            Object obj = null;
            for (int i = 0; i < this.m_maps.size(); ++i) {
                obj = this.m_maps.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorMap)) continue;
                ((VWSIMAnimatorMap)obj).releaseResources();
            }
            this.m_maps.removeAllElements();
            this.m_maps = null;
            Object var1_1 = null;
        }
    }
}

